//
//  AuthenticationScreenViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 17.02.23.
//

import UIKit
import Firebase

// https://www.youtube.com/watch?v=vI7m5RTYNng
// https://www.youtube.com/watch?v=ZiYwOB3j-SI
class AuthenticationScreenViewController : UICollectionViewController, UICollectionViewDelegateFlowLayout {
    
    var waitForIt : Bool = false
    
    let dispatchGroup = DispatchGroup()
    
    fileprivate let cellId = "cellId"
    
    fileprivate let zeroButtonCellId = "zeroButtonCellId"
    
    fileprivate let passwordheaderId = "passwordheaderId"
    fileprivate let registrationFooterCellId = "registrationFooterCellId"
    
    fileprivate let deleteButtonCellId = "deleteButtonCellId"
    
    fileprivate let confirmButtonCellId = "confirmButtonCellId"
    
    fileprivate var changeCellColorForLoginAnimation : Bool = false
    
    var animateBool = false
    
    var stopAllAnimationBool = false
    
    let numbers = ["1", "2", "3", "4", "5", "6", "7", "8", "9"] // , "*", "0", "**"
    
    let testLabel = UILabel()
    
    var correctPIN = false
    
    
    private lazy var homeButton : UIButton = {
        let homeButton = UIButton(frame: .zero)
        homeButton.translatesAutoresizingMaskIntoConstraints = false
        homeButton.setImage(UIImage(systemName: "house.fill")?.withTintColor(.white, renderingMode: .alwaysOriginal), for: .normal)
        //homeButton.showsMenuAsPrimaryAction = true
        //homeButton.menu = menu
        
        return homeButton
    }()
    
    private lazy var informationButton : UIButton = {
        let informationButton = UIButton(frame: .zero)
        informationButton.translatesAutoresizingMaskIntoConstraints = false
        informationButton.setImage(UIImage(systemName: "ellipsis")?.withTintColor(.white, renderingMode: .alwaysOriginal), for: .normal)
        informationButton.showsMenuAsPrimaryAction = true
        informationButton.menu = menu
        
        return informationButton
    }()
    
    private lazy var menu = UIMenu(title: "", options: .displayInline ,children: elements)
    
    private lazy var informationMenuItem1 = UIAction(title: "Aktualisieren", image: UIImage(systemName: "arrow.clockwise.circle.fill")?.withTintColor(UIColor(red: 30.0/255.0, green: 91.0/255.0, blue: 158.0/255.0, alpha: 1.0), renderingMode: .alwaysOriginal), attributes: [], state: .off) { action in self.reloadAuthenticationView()
    }
    
    private lazy var informationMenuItem2 = UIAction(title: "Datenschutz", image: UIImage(systemName: "lock.circle.fill")?.withTintColor(UIColor(red: 30.0/255.0, green: 91.0/255.0, blue: 158.0/255.0, alpha: 1.0), renderingMode: .alwaysOriginal), attributes: [], state: .off) { action in self.dataProtectionInformationViewTransmition()
    }
    
    private lazy var informationMenuItem3 = UIAction(title: "Impressum", image: UIImage(systemName: "doc.plaintext.fill")?.withTintColor(UIColor(red: 30.0/255.0, green: 91.0/255.0, blue: 158.0/255.0, alpha: 1.0), renderingMode: .alwaysOriginal), attributes: [], state: .off) { action in self.aboutAppInformationViewTransmition()
    }
    
    private lazy var informationMenuItem4 = UIAction(title: "App Version", image: UIImage(systemName: "info.circle.fill")?.withTintColor(UIColor(red: 30.0/255.0, green: 91.0/255.0, blue: 158.0/255.0, alpha: 1.0), renderingMode: .alwaysOriginal), attributes: [], state: .off) { action in self.appVersionAlert()
    }
    
    private lazy var elements: [UIAction] = [informationMenuItem1, informationMenuItem2, informationMenuItem3, informationMenuItem4]
    
    override func viewDidLoad() {
        
        super.viewDidLoad()
        
        showBackButtonPublic = true
        dataProtectionCalledFromHomeVCPublic = false
        
        view.addSubview(homeButton)
        addConstraintsHomeButton()
        
        
        let buttonHome:UIButton = UIButton(frame: CGRect(x: 0, y: 0, width: 30, height: 30))
        buttonHome.backgroundColor = UIColor.clear
        buttonHome.setImage(UIImage(systemName: "homeButton"), for: .normal)
        buttonHome.tintColor = .white
        
        buttonHome.addTarget(self, action: #selector(pressedHomeButton(_ :)), for: .touchUpInside)
        view.addSubview(buttonHome)
        
        buttonHome.translatesAutoresizingMaskIntoConstraints = false
        buttonHome.topAnchor.constraint(equalTo: view.topAnchor, constant: 50).isActive = true
        //button.leadingAnchor.constraint(equalTo: view.leadingAnchor).isActive = true
        buttonHome.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 20).isActive = true
        //buttonHome.isHidden = true
        
        
        
        // https://medium.com/@rohit236c/ios-pull-down-menus-the-newer-way-of-interaction-a255ceb3a28e
        // rotate ... - Button
        informationButton.transform = CGAffineTransform(rotationAngle: -CGFloat.pi / 2.0)
        view.addSubview(informationButton)
        addConstraintsTopBarButton()
        
        let button:UIButton = UIButton(frame: CGRect(x: 0, y: 0, width: 30, height: 30))
        button.backgroundColor = UIColor.clear
        // rotate ... - Button
        button.transform = CGAffineTransform(rotationAngle: -CGFloat.pi / 2.0)
        
        button.setTitle("", for: UIControl.State.normal)
        button.setImage(UIImage(systemName: "ellipsis"), for: .normal)
        button.tintColor = .white
        
        button.addTarget(self, action: #selector(pressedTopBarButton(_ :)), for: .touchUpInside)
        view.addSubview(button)
        
        button.translatesAutoresizingMaskIntoConstraints = false
        button.topAnchor.constraint(equalTo: view.topAnchor, constant: 50).isActive = true
        //button.leadingAnchor.constraint(equalTo: view.leadingAnchor).isActive = true
        button.trailingAnchor.constraint(equalTo: view.trailingAnchor, constant: -20).isActive = true
        button.isHidden = true
        
        
        
        let registrationButton: UIButton = UIButton(frame: CGRect(x: 0, y: 0, width: 30, height: 30))
        registrationButton.backgroundColor = UIColor.clear
        
        registrationButton.setTitle("Haven't set up your PIN yet?", for: UIControl.State.normal) // Noch keine App-PIN?
        registrationButton.tintColor = .white
        registrationButton.titleLabel?.font = .systemFont(ofSize: 16, weight: .light)
        //registrationButton.addTarget(self, action:#selector(self.buttonClicked), forControlEvents: .TouchUpInside)
        registrationButton.addTarget(self, action: #selector(pressed(_ :)), for: .touchUpInside)
        view.addSubview(registrationButton)
        
        registrationButton.translatesAutoresizingMaskIntoConstraints = false
        registrationButton.bottomAnchor.constraint(equalTo: view.bottomAnchor, constant: -20).isActive = true
        registrationButton.centerXAnchor.constraint(equalTo: view.centerXAnchor).isActive = true
        
        
        
        
        // add keyboard from KeyCell swift file...
        collectionView.register(KeyCell.self, forCellWithReuseIdentifier: cellId)
        
        collectionView.register(ZeroButtonCell.self, forCellWithReuseIdentifier: zeroButtonCellId)
        
        collectionView.register(DeleteCell.self, forCellWithReuseIdentifier: deleteButtonCellId)
        
        // add password line
        collectionView.register(PasswordHeader.self, forSupplementaryViewOfKind: UICollectionView.elementKindSectionHeader, withReuseIdentifier: passwordheaderId)
        //collectionView.register(RegistrationFooter.self, forSupplementaryViewOfKind: UICollectionView.elementKindSectionFooter, withReuseIdentifier: registrationFooterCellId)

        
        let bgView = UIView(frame: collectionView.bounds)
        let gradientLayer = CAGradientLayer()
        gradientLayer.frame = view.frame
        let colorTop =  UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0).cgColor
        let  colorBottom = UIColor(red: 67.0/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0).cgColor
        
        gradientLayer.colors = [colorTop, colorBottom]
        gradientLayer.locations = [0.0, 1.0]
        

        bgView.layer.insertSublayer(gradientLayer, at: 0)
        collectionView.backgroundView = bgView
        
        // open QualtricsNotificationAuthenticationScreenViewController if user does not continued Qualtrics Survey with validation code (i.e., finished app transaction, but not continued survey in qualtrics until a certain questio group)
        if lockAppPIN_SurveyIncompletePublic == true {
            if appPINPublic != developerAppPINPublic {
                // see solutions to present view controller here: https://stackoverflow.com/questions/11862883/attempt-to-present-uiviewcontroller-on-uiviewcontroller-whose-view-is-not-in-the
                DispatchQueue.main.async { [weak self] in
                    let storyboard = UIStoryboard(name: "Main", bundle: nil)
                    let nc = storyboard.instantiateViewController(withIdentifier: "QualtricsNotificationAuthenticationScreenNC")
                    nc.modalPresentationStyle = .custom
                    nc.transitioningDelegate = self
                    self?.present(nc, animated: true, completion: nil)
                    
                    print("Dismiss Authentication Screen")
                }
            }
        }
    }
    
    
    // set background color with gradient
    // https://stackoverflow.com/questions/24380535/how-to-apply-gradient-to-background-view-of-ios-swift-app
    func setGradientBackground() {
        let colorTop =  UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0).cgColor
        let  colorBottom = UIColor(red: 67.0/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0).cgColor
        
        let gradientLayer = CAGradientLayer()
        gradientLayer.colors = [colorTop, colorBottom]
        gradientLayer.locations = [0.0, 1.0]
        gradientLayer.frame = collectionView.bounds
        
        collectionView.layer.insertSublayer(gradientLayer, at:1)
    }
    
    var passwordDisplayString = ""
    
    // Change displayed numbers
    override func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        print(indexPath.item)
        
        let generator = UIImpactFeedbackGenerator(style: .light)
        generator.impactOccurred()
        
        
        // Delete Button Cell
        if indexPath.item == 1 && indexPath.section == 1 {
            passwordDisplayString = String(passwordDisplayString.dropLast())
            deleteCell = true
            
        } else if indexPath.item == 0 && indexPath.section == 1{
            passwordDisplayString += "0"
            deleteCell = false
        } else {
            let number = numbers[indexPath.item]
            passwordDisplayString += number
            deleteCell = false
        }
        
        
        
        
        
        // PIN is correct
        //if passwordDisplayString == "000000" || passwordDisplayString == "187765"{
        if passwordDisplayString.count == 6 {
            
            
            var timeoutError = false
            
            dispatchGroup.enter()
            
            validatePIN(string: passwordDisplayString) {fieldPIN, fieldUserID, fieldValidationCode, fieldScenario, fieldLockAppPIN_SurveyIncomplete, fieldLockDBForScenarioAppPIN_TransactionSuccessful, fieldTimestamp_Qualtrics  in
                if let fieldPIN = fieldPIN, let fieldUserID = fieldUserID, let fieldValidationCode = fieldValidationCode, let fieldScenario = fieldScenario, let fieldLockAppPIN_SurveyIncomplete = fieldLockAppPIN_SurveyIncomplete, let fieldLockDBForScenarioAppPIN_TransactionSuccessful = fieldLockDBForScenarioAppPIN_TransactionSuccessful, let fieldTimestamp_Qualtrics = fieldTimestamp_Qualtrics {
                    // cell color change done in "cellForItemAt"
                    self.changeCellColorForLoginAnimation = true
                    /*### ACHTUNG ###*/
                    //verifyUserPIN(userappPIN: passwordDisplayString)
                    print("Correct PIN: \(self.correctPIN)")
                    self.correctPIN = true
                    
                    self.waitForIt = false

                    let cell = collectionView.dequeueReusableCell(withReuseIdentifier: self.cellId, for: indexPath) as! KeyCell
                    cell.isUserInteractionEnabled = false
                    collectionView.reloadData()
                    let screenSize: CGRect = self.view.bounds
                    
                    let animatedRadius = 50.0
                    //let screenCentered = CGRect(x: self.view.bounds.midX, y: self.view.bounds.midY, width: animatedRadius, height: animatedRadius)
                    
                    let myView = SpinnerView(frame: CGRect(x: screenSize.width/2 - ( animatedRadius * 0.5), y: screenSize.height-300.0, width: 50, height: 50))
                    self.view.addSubview(myView)
                    
                } else {
                    self.passwordDisplayString = ""
                    collectionView.reloadData()
                    print("Document (=appPIN) or one of these three first validated fields does not exist in DB")
                    
                    self.waitForIt = false
                }
                
                
            }
            dispatchGroup.leave()
            
            //dispatchGroup.wait()
            
            //dispatchGroup?.notify(queue: .main) {
            //}
            if dispatchGroup.wait(timeout: .now() + 3) == .timedOut {
                timeoutError = true
                print("Timeout nach 3 Sekunden!")
            }
            
            // hier geht das Programm weiter, unabhängig davon, ob das Ergebnis der Funktion vorliegt oder nicht
            
            if timeoutError {
                print("Error connection to DB or error in DB fields")
                let cell = collectionView.dequeueReusableCell(withReuseIdentifier: cellId, for: indexPath) as! KeyCell
                cell.isUserInteractionEnabled = false
                
                let timeoutErrorLabel = UILabel()
                timeoutErrorLabel.text = "Bitte Internetverbindung prüfen. Alternativ später erneut probieren."
                
                self.view.addSubview(timeoutErrorLabel)
                timeoutErrorLabel.centerInSuperview()
                
                DispatchQueue.main.asyncAfter(deadline: .now() + 3.0) {
                    self.reloadAuthenticationView()
                }
            }
            
            
        }
        

        if passwordDisplayString.count == 6{
            //passwordDisplayString = ""
            waitForIt = true
        }
        
        
        if passwordDisplayString.count == 0 { //|| passwordDisplayString.count == 0
            collectionView.reloadData()
            DispatchQueue.main.asyncAfter(deadline: .now()) {
                //collectionView.reloadData()
            }
        } else {
            collectionView.reloadData()
        }
        
    }
    
    func validatePIN(string: String, completion: @escaping (String?, String?, String?, Int?, Bool?, Bool?, String?) -> Void) { // Timestamp?
        let docRef = Firestore.firestore().collection(qualtricsOnlineBankingDBPublic).document(string)
        docRef.getDocument { (document, error) in
            if let document = document, document.exists {
                let dataDescription = document.data().map(String.init(describing:)) ?? "nil"
                
                //Example output: Document data: ["password": test, "username": Test, "email": Test]
                print("Document data: \(dataDescription)")
                
                //document.data Output: Optional(["password": test, "username": Test, "email": Test])
                print("\(document.data())")
                
                // get app PIN
                let fieldPIN = document.get("appPIN") as! String
                // Set appPIN in App equal to userappPIN
                appPINPublic = fieldPIN
                print("Your PIN is: \(appPINPublic)")
                
                let fieldUserID = document.get("userID") as! String
                // Set appPIN in App equal to userappPIN
                userIDPublic = fieldUserID
                print("Your user ID is: \(userIDPublic)")
                
                let fieldValidationCode = document.get("validationCode") as! String
                validationCodePublic = fieldValidationCode
                print("Validation Code is: \(validationCodePublic)")
                
                let fieldScenario = document.get("scenario") as! Int
                scenarioPublic = fieldScenario
                print("Scenario is: \(scenarioPublic)")
                
                let fieldLockAppPIN_SurveyIncomplete = document.get("lockAppPIN_SurveyIncomplete") as! Bool
                lockAppPIN_SurveyIncompletePublic = fieldLockAppPIN_SurveyIncomplete
                
                let fieldLockDBForScenarioAppPIN_TransactionSuccessful = document.get("lockDBForScenarioAppPIN_TransactionSuccessful") as! Bool
                lockDBForScenarioAppPIN_TransactionSuccessfulPublic = fieldLockDBForScenarioAppPIN_TransactionSuccessful
                
                let fieldTimestamp_Qualtrics = document.get("timestamp_Qualtrics") as! String//Timestamp
                
                timestamp_QualtricsPublic = fieldTimestamp_Qualtrics// dateString
                
                
                
                completion(fieldPIN, fieldUserID, fieldValidationCode, fieldScenario, fieldLockAppPIN_SurveyIncomplete, fieldLockDBForScenarioAppPIN_TransactionSuccessful, fieldTimestamp_Qualtrics)
            } else {
                completion(nil, nil, nil, nil, nil, nil, nil)
            }
        }
    }
    
    var testvar = 0
    
    
    // https://stackoverflow.com/questions/29655652/how-to-make-both-header-and-footer-in-collection-view-with-swift
    override func collectionView(_ collectionView: UICollectionView, viewForSupplementaryElementOfKind kind: String, at indexPath: IndexPath) -> UICollectionReusableView {
        //dispatchGroup.wait()
        
        let passwordHeader = collectionView.dequeueReusableSupplementaryView(ofKind: kind, withReuseIdentifier: passwordheaderId, for: indexPath) as! PasswordHeader
        passwordHeader.passwordLabel.text = passwordDisplayString
        
        switch kind {
            
        case UICollectionView.elementKindSectionHeader:
            
            
            
            if !waitForIt {
                
                testvar += passwordDisplayString.count
                
                print("current PIN:")
                print(passwordDisplayString)
                
                if testvar == 1 {
                    animateBool = true
                }
                
                // delete button cell
                if deleteCell == true {
                    print(passwordDisplayString.count)
                    // Delete Button Cell
                    if passwordDisplayString.count+1 == 1 {
                        passwordHeader.circleDigit1.backgroundColor = UIColor.clear
                    } else if passwordDisplayString.count+1 == 2 {
                        passwordHeader.circleDigit2.backgroundColor = UIColor.clear
                    } else if passwordDisplayString.count+1 == 3 {
                        passwordHeader.circleDigit3.backgroundColor = UIColor.clear
                    } else if passwordDisplayString.count+1 == 4 {
                        passwordHeader.circleDigit4.backgroundColor = UIColor.clear
                    } else if passwordDisplayString.count+1 == 5 {
                        passwordHeader.circleDigit5.backgroundColor = UIColor.clear
                    }
                }
                
                else {
                    if passwordDisplayString.count == 1 {
                        stopAllAnimationBool = true
                        //passwordHeader.circleDigit1.layer.removeAllAnimations()
                        // remove animation before next user input appears...
                        passwordHeader.circleDigit1.backgroundColor = UIColor.clear
                        passwordHeader.circleDigit2.backgroundColor = UIColor.clear
                        passwordHeader.circleDigit3.backgroundColor = UIColor.clear
                        passwordHeader.circleDigit4.backgroundColor = UIColor.clear
                        passwordHeader.circleDigit5.backgroundColor = UIColor.clear
                        passwordHeader.circleDigit6.backgroundColor = UIColor.clear
                        passwordHeader.circleDigit1.layer.borderColor = UIColor.white.cgColor
                        passwordHeader.circleDigit2.layer.borderColor = UIColor.white.cgColor
                        passwordHeader.circleDigit3.layer.borderColor = UIColor.white.cgColor
                        passwordHeader.circleDigit4.layer.borderColor = UIColor.white.cgColor
                        passwordHeader.circleDigit5.layer.borderColor = UIColor.white.cgColor
                        passwordHeader.circleDigit6.layer.borderColor = UIColor.white.cgColor
                        
                        passwordHeader.passwordFirstDigitLabel.text = passwordDisplayString[0]
                        
                        passwordHeader.circleDigit1.backgroundColor = UIColor.white
                    } else if passwordDisplayString.count == 2{
                        passwordHeader.passwordSecondDigitLabel.text = passwordDisplayString[1]
                        passwordHeader.circleDigit2.backgroundColor = UIColor.white
                    } else if passwordDisplayString.count == 3{
                        passwordHeader.passwordThirdDigitLabel.text = passwordDisplayString[2]
                        passwordHeader.circleDigit3.backgroundColor = UIColor.white
                    } else if passwordDisplayString.count == 4{
                        passwordHeader.passwordFourthDigitLabel.text = passwordDisplayString[3]
                        passwordHeader.circleDigit4.backgroundColor = UIColor.white
                    } else if passwordDisplayString.count == 5{
                        passwordHeader.passwordFifthDigitLabel.text = passwordDisplayString[4]
                        passwordHeader.circleDigit5.backgroundColor = UIColor.white
                    } else if passwordDisplayString.count == 0 && animateBool && correctPIN == false{
                        stopAllAnimationBool = false
                        let redColor = UIColor(red: 120.0/255.0, green: 22/255.0, blue: 13/255.0, alpha: 1.0) // UIColor(red: 211/255.0, green: 11/255.0, blue: 29/255.0, alpha: 1.0)
                        
                        passwordHeader.passwordSixhDigitLabel.text = passwordDisplayString[5]
                        passwordHeader.circleDigit6.backgroundColor = UIColor.white
                        
                        
                        passwordHeader.circleDigit1.backgroundColor = redColor // UIColor(red: 120.0/255.0, green: 22/255.0, blue: 13/255.0, alpha: 1.0)
                        passwordHeader.circleDigit1.layer.borderColor = UIColor.clear.cgColor
                        self.shakePINField(PINfield: passwordHeader.circleDigit1)
                        passwordHeader.circleDigit2.backgroundColor = redColor // UIColor(red: 226/255.0, green: 8/255.0, blue: 18/255.0, alpha: 1.0)
                        passwordHeader.circleDigit2.layer.borderColor = UIColor.clear.cgColor
                        self.shakePINField(PINfield: passwordHeader.circleDigit2)
                        passwordHeader.circleDigit3.backgroundColor = redColor
                        passwordHeader.circleDigit3.layer.borderColor = UIColor.clear.cgColor
                        self.shakePINField(PINfield: passwordHeader.circleDigit3)
                        passwordHeader.circleDigit4.backgroundColor = redColor
                        passwordHeader.circleDigit4.layer.borderColor = UIColor.clear.cgColor
                        self.shakePINField(PINfield: passwordHeader.circleDigit4)
                        passwordHeader.circleDigit5.backgroundColor = redColor
                        passwordHeader.circleDigit5.layer.borderColor = UIColor.clear.cgColor
                        self.shakePINField(PINfield: passwordHeader.circleDigit5)
                        passwordHeader.circleDigit6.backgroundColor = redColor
                        passwordHeader.circleDigit6.layer.borderColor = UIColor.clear.cgColor
                        self.shakePINField(PINfield: passwordHeader.circleDigit6)
                        
                        wrongPINCounter()
                        
                        
                        let generator = UIImpactFeedbackGenerator(style: .medium)
                        generator.impactOccurred()
                        DispatchQueue.main.asyncAfter(deadline: .now() + 0.1) {
                            generator.impactOccurred()
                        }
                        DispatchQueue.main.asyncAfter(deadline: .now() + 0.2) {
                            generator.impactOccurred()
                        }
                        DispatchQueue.main.asyncAfter(deadline: .now() + 0.3) {
                            generator.impactOccurred()
                        }
                        
                        DispatchQueue.main.asyncAfter(deadline: .now() + 1) {
                            if (!self.stopAllAnimationBool) {
                                passwordHeader.circleDigit1.backgroundColor = UIColor.clear
                                passwordHeader.circleDigit2.backgroundColor = UIColor.clear
                                passwordHeader.circleDigit3.backgroundColor = UIColor.clear
                                passwordHeader.circleDigit4.backgroundColor = UIColor.clear
                                passwordHeader.circleDigit5.backgroundColor = UIColor.clear
                                passwordHeader.circleDigit6.backgroundColor = UIColor.clear
                                passwordHeader.circleDigit1.layer.borderColor = UIColor.white.cgColor
                                passwordHeader.circleDigit2.layer.borderColor = UIColor.white.cgColor
                                passwordHeader.circleDigit3.layer.borderColor = UIColor.white.cgColor
                                passwordHeader.circleDigit4.layer.borderColor = UIColor.white.cgColor
                                passwordHeader.circleDigit5.layer.borderColor = UIColor.white.cgColor
                                passwordHeader.circleDigit6.layer.borderColor = UIColor.white.cgColor
                            }
                        }
                    }
                    
                    // PASSWORD CORRECT - DELETE || statement here!!!
                    else if(correctPIN) {
                        //print("HERE:")
                        //print(passwordDisplayString)
                        //if(verifyUserPIN(userappPIN: passwordDisplayString) || correctPIN || passwordDisplayString=="187765") {
                        
                        print("Correct PIN. Start animation")
                        print(passwordDisplayString)
                        // do something here...
                        passwordHeader.passwordSecondDigitLabel.text = passwordDisplayString[5]
                        passwordHeader.circleDigit6.backgroundColor = UIColor.white
                        
                        let greenColor = UIColor.init(red: 21/255, green: 65/255, blue: 115/255, alpha: 1) // UIColor.init(red: 58/255, green: 181/255, blue: 78/255, alpha: 1)
                        passwordHeader.circleDigit1.backgroundColor = greenColor // UIColor(red: 120.0/255.0, green: 22/255.0, blue: 13/255.0, alpha: 1.0)
                        passwordHeader.circleDigit1.layer.borderColor = UIColor.clear.cgColor
                        passwordHeader.circleDigit2.backgroundColor = greenColor // UIColor(red: 226/255.0, green: 8/255.0, blue: 18/255.0, alpha: 1.0)
                        passwordHeader.circleDigit2.layer.borderColor = UIColor.clear.cgColor
                        passwordHeader.circleDigit3.backgroundColor = greenColor
                        passwordHeader.circleDigit3.layer.borderColor = UIColor.clear.cgColor
                        passwordHeader.circleDigit4.backgroundColor = greenColor
                        passwordHeader.circleDigit4.layer.borderColor = UIColor.clear.cgColor
                        passwordHeader.circleDigit5.backgroundColor = greenColor
                        passwordHeader.circleDigit5.layer.borderColor = UIColor.clear.cgColor
                        passwordHeader.circleDigit6.backgroundColor = greenColor
                        passwordHeader.circleDigit6.layer.borderColor = UIColor.clear.cgColor
                        
                        let seconds = 2.5 // 0.35
                        DispatchQueue.main.asyncAfter(deadline: .now() + seconds) {
                            // login
                            if lockAppPIN_SurveyIncompletePublic == false {
                                let storyboard = UIStoryboard(name: "Main", bundle: nil)
                                let tabBarController = storyboard.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
                                
                                self.view.window?.rootViewController = tabBarController
                                self.view.window?.makeKeyAndVisible()
                                
                                // open QualtricsNotificationAuthenticationScreenViewController if user does not continued Qualtrics Survey with validation code (i.e., finished app transaction, but not continued survey in qualtrics until a certain questio group)
                            } else {
                                // see solutions to present view controller here: https://stackoverflow.com/questions/11862883/attempt-to-present-uiviewcontroller-on-uiviewcontroller-whose-view-is-not-in-the
                                DispatchQueue.main.async { [weak self] in
                                    let storyboard = UIStoryboard(name: "Main", bundle: nil)
                                    let nc = storyboard.instantiateViewController(withIdentifier: "QualtricsNotificationAuthenticationScreenNC")
                                    nc.modalPresentationStyle = .custom
                                    nc.transitioningDelegate = self
                                    self?.present(nc, animated: true, completion: nil)
                                    
                                    print("Dismiss Authentication Screen")
                                }
                            }
                        }
                    }
                    //}
                }
                deleteCell = false
            } else {
                passwordHeader.circleDigit1.backgroundColor = UIColor.white
                passwordHeader.circleDigit2.backgroundColor = UIColor.white
                passwordHeader.circleDigit3.backgroundColor = UIColor.white
                passwordHeader.circleDigit4.backgroundColor = UIColor.white
                passwordHeader.circleDigit5.backgroundColor = UIColor.white
                passwordHeader.circleDigit6.backgroundColor = UIColor.white
                passwordHeader.circleDigit1.layer.borderColor = UIColor.clear.cgColor
                passwordHeader.circleDigit2.layer.borderColor = UIColor.clear.cgColor
                passwordHeader.circleDigit3.layer.borderColor = UIColor.clear.cgColor
                passwordHeader.circleDigit4.layer.borderColor = UIColor.clear.cgColor
                passwordHeader.circleDigit5.layer.borderColor = UIColor.clear.cgColor
                passwordHeader.circleDigit6.layer.borderColor = UIColor.clear.cgColor
            }
            return passwordHeader
            
            /*
             case UICollectionView.elementKindSectionFooter:
             let registrationFooter = collectionView.dequeueReusableSupplementaryView(ofKind: kind, withReuseIdentifier: registrationFooterCellId, for: indexPath) as! RegistrationFooter
             return registrationFooter
             */
        default:
            assert(false, "Unexpected element kind")
        }
        
        return passwordHeader
    }
    
    
    
    // set vertical height of header space
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, referenceSizeForHeaderInSection section: Int) -> CGSize {
        if section == 1 {
            return .zero
        }
        let height = view.frame.height * 0.4
        return .init(width: view.frame.width, height: height)
    }
    // set vertical height of footer space
    /*
     func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, referenceSizeForFooterInSection section: Int) -> CGSize {
     if section ==  0 {
     return .zero
     }
     let height = view.frame.height * 0.01
     return .init(width: view.frame.width, height: height)
     }
     */
    
    // section number
    override func numberOfSections(in collectionView: UICollectionView) -> Int {
        return 2
    }
    
    override func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        // show TWO cells in section 1
        if section == 1 {
            return 2
        }
        return numbers.count
    }
    
    // add numbers to cells
    override func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        //dispatchGroup.wait()
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: cellId, for: indexPath) as! KeyCell
        cell.digitsLabel.text = numbers[indexPath.item]
        
        if changeCellColorForLoginAnimation {
            cell.backgroundColor = .clear
            cell.digitsLabel.textColor = .clear
            cell.isUserInteractionEnabled = false
        }
        
        // deactivate user interaction during waiting time for Firebase DB (after 6 digits)
        if waitForIt {
            cell.isUserInteractionEnabled = false
            // delay user interaction
            DispatchQueue.main.asyncAfter(deadline: .now() + 1) {
                cell.isUserInteractionEnabled = true
            }
        }

        
        // section
        if indexPath.section == 1 {
            // first cell...
            if indexPath.item == 0 {
                let zeroButtonCell = collectionView.dequeueReusableCell(withReuseIdentifier: zeroButtonCellId, for: indexPath) as! ZeroButtonCell
                zeroButtonCell.zeroDigit.text = "0"
                if changeCellColorForLoginAnimation {
                    zeroButtonCell.backgroundColor = .clear
                    zeroButtonCell.zeroDigit.textColor = .clear
                    zeroButtonCell.isUserInteractionEnabled = false
                }
                return zeroButtonCell
                // second cell...
            } else {
                let deleteCell = collectionView.dequeueReusableCell(withReuseIdentifier: deleteButtonCellId, for: indexPath) as! DeleteCell
                if changeCellColorForLoginAnimation {
                    deleteCell.backgroundColor = .clear
                    deleteCell.isUserInteractionEnabled = false
                    //deleteCell.willRemoveSubview()
                    for view in deleteCell.subviews {
                        view.removeFromSuperview()
                    }
                }
                return deleteCell
            }
            
        }
        
        // MODIFY HERE
        //cell.digitsLabel.text.insert
        return cell
    }
    
    // spacing to main view left and right
    lazy var leftRightPadding = view.frame.width * 0.13
    // spacing between cells
    lazy var interSpacing = view.frame.width * 0.1
    
    lazy var cellWidth = (view.frame.width - 2 * leftRightPadding - 2 * interSpacing) / 3 * 1.0
    
    // number cell size
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        return .init(width: cellWidth, height: cellWidth)
    }
    
    // vertical cell spacing
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumLineSpacingForSectionAt section: Int) -> CGFloat {
        return 16
    }
    
    // spacing between cells
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, insetForSectionAt section: Int) -> UIEdgeInsets {
        
        if section == 1 {
            let leftPadding = (view.frame.width) / 2 - cellWidth / 2
            return .init(top: 0, left: leftPadding, bottom: 0, right: self.leftRightPadding)
        }
        
        // space between view border (on left and right side) and outer cells
        let leftRightPadding = view.frame.width * 0.13
        
        return .init(top: 16, left: leftRightPadding, bottom: 16, right: leftRightPadding)
    }
    
    
    
    func shakePINField (PINfield: UIView) {
        let animation = CABasicAnimation(keyPath: "position")
        animation.duration = 0.07
        animation.repeatCount = 3
        animation.autoreverses = true
        animation.fromValue = NSValue(cgPoint: CGPoint(x: PINfield.center.x - 5, y: PINfield.center.y))
        animation.toValue = NSValue(cgPoint: CGPoint(x: PINfield.center.x + 5, y: PINfield.center.y))
        PINfield.layer.add(animation, forKey: "position")
        
    }
    
    func reloadAuthenticationView() {
        print("Reload current view")
        
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "TEST55")
        
        let layout = UICollectionViewFlowLayout()
        self.view.window?.rootViewController = AuthenticationScreenViewController(collectionViewLayout: layout)
        
        self.view.window?.rootViewController = vc
        self.view.window?.makeKeyAndVisible()
    }
    
    func dataProtectionInformationViewTransmition() {
        print("DataProtectionInformationNC")
        
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let navigationController = storyboard.instantiateViewController(withIdentifier: "DataProtectionInformationNC") as! UINavigationController
        
        navigationController.modalPresentationStyle = .popover
        //navigationBarController.modalTransitionStyle = .crossDissolve
        
        present(navigationController, animated: true)
        
    }
    
    func aboutAppInformationViewTransmition() {
        print("AboutAppInformationNC")
        
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let navigationController = storyboard.instantiateViewController(withIdentifier: "AboutAppInformationNC") as! UINavigationController
        
        navigationController.modalPresentationStyle = .popover
        //navigationBarController.modalTransitionStyle = .crossDissolve
        
        present(navigationController, animated: true)
        
    }
    
    
    func appVersionAlert() {
        // create the alert
        let alert = UIAlertController(title: "App Version", message: "App Version 1.0", preferredStyle: UIAlertController.Style.alert)
        
        // add an action (button)
        alert.addAction(UIAlertAction(title: "Okay", style: UIAlertAction.Style.default, handler: nil))
        
        // show the alert
        self.present(alert, animated: true, completion: nil)
    }
    
    
    func verifyPIN(userAppPIN: String) -> Bool {
        let db = Firestore.firestore()
        let docRef = db.collection(qualtricsOnlineBankingDBPublic).document("\(userAppPIN)")
        
        var PINCorrect = false
        
        let semaphore = DispatchSemaphore(value: 0)
        
        // Warten auf das Ergebnis der Datenbankabfrage
        docRef.getDocument { (document, error) in
            defer {
                semaphore.signal()
            }
            
            if let document = document, document.exists {
                PINCorrect = true
            } else {
                PINCorrect =  false
            }
        }
        
        // Blockieren, bis das Semaphore-Signal erhöht wird
        semaphore.wait()
        
        return PINCorrect
    }
    
    
    private func wrongPINCounter() {
        wrongPINCounterPublic += 1
    }
    
    private func addConstraintsHomeButton() {

        homeButton.translatesAutoresizingMaskIntoConstraints = false
        homeButton.topAnchor.constraint(equalTo: view.topAnchor, constant: 50).isActive = true
        homeButton.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 20).isActive = true
        homeButton.widthAnchor.constraint(equalToConstant: 30).isActive = true
        homeButton.heightAnchor.constraint(equalToConstant: 30).isActive = true

        homeButton.backgroundColor = UIColor.clear
    }
    
    
    private func addConstraintsTopBarButton() {

        informationButton.translatesAutoresizingMaskIntoConstraints = false
        informationButton.topAnchor.constraint(equalTo: view.topAnchor, constant: 50).isActive = true
        //button.leadingAnchor.constraint(equalTo: view.leadingAnchor).isActive = true
        informationButton.trailingAnchor.constraint(equalTo: view.trailingAnchor, constant: -20).isActive = true
        informationButton.widthAnchor.constraint(equalToConstant: 30).isActive = true
        informationButton.heightAnchor.constraint(equalToConstant: 30).isActive = true

        informationButton.backgroundColor = UIColor.clear
    }
    
    
    @objc func pressedTopBarButton(_ sender: UIButton) {
        print("Top Bar Button Pressed")
        
    }
    
    @objc func pressedHomeButton(_ sender: UIButton) {
        print("Home Button Pressed")
        
        
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let tabBarController = storyboard.instantiateViewController(withIdentifier: "InitialTBC") as! UITabBarController
        
        self.view.window?.rootViewController = tabBarController
        self.view.window?.makeKeyAndVisible()
        
    }
    
    @objc func pressed(_ sender: UIButton) {
        print("Registration Button Pressed")
        
        // Fallback...
        if #available(iOS 15.0, *) {
            let storyboard = UIStoryboard(name: "Main", bundle: nil)
            let nc = storyboard.instantiateViewController(withIdentifier: "NewRegistrationNC")
            
            
            if let presentationController = nc.presentationController as? UISheetPresentationController {
                
                presentationController.detents = [.medium()] /// change to [.medium(), .large()] for a half *and* full screen sheet
            }
            self.present(nc, animated: true)
            
        } else {
            let storyboard = UIStoryboard(name: "Main", bundle: nil)
                    let viewController = storyboard.instantiateViewController(withIdentifier: "NewRegistrationVC")
            viewController.modalPresentationStyle = .custom
            viewController.transitioningDelegate = self
            self.present(viewController, animated: true, completion: nil)
        }
        
    }
}

// MARK: - UIViewControllerTransitioningDelegate
extension AuthenticationScreenViewController: UIViewControllerTransitioningDelegate {
    
    func presentationController(forPresented presented: UIViewController, presenting: UIViewController?, source: UIViewController) -> UIPresentationController? {
        QualtricsNotificationAuthenticationScreenPresentationController(presentedViewController: presented, presenting: presenting)
    }
}
